clc;
close all;
%% Load 10 identical simulated ATS coarse crackles here 
load SC1_ATS
load SC2_ATS
load SC3_ATS
load SC4_ATS
load SC5_ATS
load SC6_ATS
load SC7_ATS
load SC8_ATS
load SC9_ATS
load SC10_ATS
fs              =44100;                                                       %% Sampling frequency
Signal_length   = 32768;                                                      %% Signal length
%% Make the length equal
SC1_ATS         = [zeros(1,1000),SC1_ATS,zeros(1,Signal_length-(1000+length(SC1_ATS)))];
SC2_ATS         = [zeros(1,3000),SC2_ATS,zeros(1,Signal_length-(3000+length(SC2_ATS)))];
SC3_ATS         = [zeros(1,7000),SC3_ATS,zeros(1,Signal_length-(7000+length(SC3_ATS)))];
SC4_ATS         = [zeros(1,12000),SC4_ATS,zeros(1,Signal_length-(12000+length(SC4_ATS)))];
SC5_ATS         = [zeros(1,14000),SC5_ATS,zeros(1,Signal_length-(14000+length(SC5_ATS)))];
SC6_ATS         = [zeros(1,17000),SC6_ATS,zeros(1,Signal_length-(17000+length(SC6_ATS)))];
SC7_ATS         = [zeros(1,20000),SC7_ATS,zeros(1,Signal_length-(20000+length(SC7_ATS)))];
SC8_ATS         = [zeros(1,23000),SC8_ATS,zeros(1,Signal_length-(23000+length(SC8_ATS)))];
SC9_ATS         = [zeros(1,27500),SC9_ATS,zeros(1,Signal_length-(27500+length(SC9_ATS)))];
SC10_ATS        = [zeros(1,30000),SC10_ATS,zeros(1,Signal_length-(30000+length(SC10_ATS)))];
Ten_identical_simulated_ATS_coarse_crackles         = SC1_ATS+SC2_ATS+SC3_ATS+SC4_ATS+SC5_ATS+SC6_ATS+SC7_ATS+SC8_ATS+SC9_ATS+SC10_ATS;
Ten_identical_simulated_ATS_coarse_crackles         = Ten_identical_simulated_ATS_coarse_crackles(1:end);
%% Plot
figure
plot(Ten_identical_simulated_ATS_coarse_crackles,'k');
xlabel('Number of samples','FontSize',12,'FontName','Times New Roman','fontweight','bold');
ylabel('Amplitude','FontSize',12,'FontName','Times New Roman','fontweight','bold');
%%
text(1150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(250,.85,'SC1-ATS','fontsize',8,'FontWeight','bold')
text(3150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(3150,.85,'SC2-ATS','fontsize',8,'FontWeight','bold')
text(7150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(7000,.85,'SC3-ATS','fontsize',8,'FontWeight','bold')
text(12150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(11150,.85,'SC4-ATS','fontsize',8,'FontWeight','bold')
text(14150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(14150,.85,'SC5-ATS','fontsize',8,'FontWeight','bold')
text(17150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(17150,.85,'SC6-ATS','fontsize',8,'FontWeight','bold')
text(20150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(20150,.85,'SC7-ATS','fontsize',8,'FontWeight','bold')
text(23150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(23150,.85,'SC8-ATS','fontsize',8,'FontWeight','bold')
text(27650,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(26500,.85,'SC9-ATS','fontsize',8,'FontWeight','bold')
text(30150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(29800,.85,'SC10-ATS','fontsize',8,'FontWeight','bold')
%%
set(gcf, 'Position',  [100, 300, 800, 300])
title('10 identical simulated ATS coarse crackles','FontSize',12,'FontName','Times New Roman','fontweight','bold');
xlim([0 Signal_length]);
ylim([-1 1]);
